//
// (c) 2020 wesolutions GmbH
// All rights reserved
//

import QtQuick 2.3

import wesual.Controls 1.0
import wesual.data.Core 1.0

Text {
    id : label

    property Product product
    property bool showCurrencyLabel : true
    property alias color : label.color

    readonly property real price : product ? product.price : -1

    readonly property string formattedPrice : {
        if (!product)
            return "";

        var currencyString = showCurrencyLabel
                ? UI.currencyString("AT", UI.fontFamily(UI.PrimaryFont)) + " "
                : "";

        return currencyString + price.toLocaleString(Qt.locale(), "f", 2);
    }

    text : formattedPrice
    visible : price > 0
}
